/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.zpe.core.YASSPredefinedFunctions;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEFunction;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEPluginManager;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPECustomFunction;
import jamiebalfour.zpe.interfaces.ZPEInternalFunction;
import java.util.HashMap;

class Manual {
    Manual() {
    }

    private static String translateReturnTypeToString(byte type) {
        switch (type) {
            case 120: {
                return "number";
            }
            case 119: {
                return "string";
            }
            case 121: {
                return "boolean";
            }
            case 124: {
                return "function";
            }
            case 122: {
                return "list";
            }
            case 123: {
                return "associative_array";
            }
            case -4: {
                return "null";
            }
        }
        return "mixed";
    }

    public static void getManualEntry(String entry) {
        Manual.getManualEntry(new ZPERuntimeEnvironment(5), entry);
    }

    public static void getManualEntry(ZPERuntimeEnvironment z, String entry) {
        Object f = z.getInternalFunction(entry);
        if (f != null) {
            if (f instanceof Class && ZPEInternalFunction.class.isAssignableFrom((Class)f)) {
                Class fn = (Class)f;
                String a = YASSPredefinedFunctions.internalAliases.get(entry);
                if (YASSPredefinedFunctions.internalAliases.containsKey(entry)) {
                    ZPE.print(ZPEHelperFunctions.setConsoleEffectToCyan(entry + " is an internal alias for " + a + ": "));
                }
                ZPE.print(ZPEHelperFunctions.setConsoleEffectToYellow(YASSPredefinedFunctions.getManualHeader(fn) + " => " + Manual.translateReturnTypeToString(YASSPredefinedFunctions.getReturnType(fn))));
                ZPE.print(YASSPredefinedFunctions.getManualEntry(fn));
                ZPE.print();
                int per = YASSPredefinedFunctions.requiredPermissionLevels(fn);
                if (per == 0) {
                    System.out.println(ZPEHelperFunctions.setConsoleEffectToGreen("Minimum permission level: none"));
                } else {
                    ZPE.print(ZPEHelperFunctions.setConsoleEffectToGreen("Minimum permission level: " + per));
                }
                ZPE.print(ZPEHelperFunctions.setConsoleEffectToGreen("Can be overwritten: " + (YASSPredefinedFunctions.getMode(fn) == 1 ? "No" : "Yes")));
                ZPE.print(ZPEHelperFunctions.setConsoleEffectToGreen("Function version " + YASSPredefinedFunctions.getVersion(fn)));
                ZPE.print();
            } else if (f instanceof ZPECustomFunction) {
                ZPECustomFunction fn = (ZPECustomFunction)f;
                String q = YASSPredefinedFunctions.internalAliases.get(entry);
                if (YASSPredefinedFunctions.internalAliases.containsKey(entry)) {
                    ZPE.print(ZPEHelperFunctions.setConsoleEffectToGreen(entry + " is an internal aliase for " + q + ": "));
                }
                ZPE.print(ZPEHelperFunctions.setConsoleEffectToGreen(fn.getManualHeader() + " -> " + Manual.translateReturnTypeToString(fn.getReturnType())));
                ZPE.print(fn.getManualEntry());
                int per = fn.getRequiredPermissionLevel();
                if (per == 0) {
                    ZPE.print("Minimum permission level: none");
                } else {
                    ZPE.print("Minimum permission level: " + per);
                }
            }
        } else if (z.globalFunction.functionMap.containsKey(entry)) {
            f = z.globalFunction.functionMap.get(entry);
            ZPEFunction fn = (ZPEFunction)f;
            StringBuilder params = new StringBuilder();
            for (int i = 0; i < fn.parameterNames.size(); ++i) {
                String param2 = fn.parameterNames.get(i);
                if (i == fn.parameterNames.size() - 1) {
                    params.append(param2);
                    continue;
                }
                params.append(param2).append(", ");
            }
            if (fn.documentation != null) {
                HashMap documentation = (HashMap)fn.documentation;
                for (String s : documentation.keySet()) {
                    String doc = (String)documentation.get(s);
                    ZPE.print("@" + doc);
                    if (doc.startsWith("\"") && doc.endsWith("\"")) {
                        doc = doc.substring(1, doc.length() - 2);
                    }
                    ZPE.print(ZPEHelperFunctions.setConsoleEffectToGreen(entry + " (" + params + ")"));
                    ZPE.print(ZPEHelperFunctions.setConsoleEffectToGreen(doc));
                }
            }
        } else {
            ZPE.print("No manual entry found.");
        }
    }

    public static void printCommands() {
        ZPERuntimeEnvironment z = new ZPERuntimeEnvironment();
        try {
            z.runStartup();
        }
        catch (ZPERuntimeException e) {
            throw new RuntimeException(e);
        }
        ZPE.print("");
        ZPE.print("ZPE aliases");
        ZPE.print("");
        for (String s : YASSPredefinedFunctions.internalAliases.keySet()) {
            ZPE.print("  " + s + " => " + YASSPredefinedFunctions.internalAliases.get(s) + ";");
        }
        ZPE.print("");
        ZPE.print("");
        ZPE.print("ZPE functions (" + ZPEInstance.BUILT_IN_COMMANDS.getCommandCount() + " available):");
        ZPE.print("");
        String lastCategory = "";
        for (String s : YASSPredefinedFunctions.getCommands()) {
            Class<? extends ZPEInternalFunction> func = YASSPredefinedFunctions.getInternalMethod(s);
            String permission_level = "" + YASSPredefinedFunctions.requiredPermissionLevels(func);
            if (!lastCategory.equals(YASSPredefinedFunctions.getCategory(func))) {
                lastCategory = YASSPredefinedFunctions.getCategory(func);
                System.out.println();
                System.out.println("  " + lastCategory + " functions");
                System.out.println();
            }
            String h = YASSPredefinedFunctions.getManualHeader(func).replace(s + " ", "");
            ZPE.print("    " + s + h);
        }
        ZPE.print("");
        ZPE.print("");
        ZPE.print("Imported native functions");
        ZPE.print("");
        for (String s : ZPEPluginManager.IMPORTED_CUSTOM_COMMANDS.keySet()) {
            ZPE.print("  " + s);
        }
        ZPE.print("");
        ZPE.print("");
    }
}

