/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.PythonTranspiler;
import jamiebalfour.zpe.SQARLEditorMain;
import jamiebalfour.zpe.SQARLParserByteCodes;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.parser.v4.ZenithParsingEngine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class SQARLParser {
    ZenithParsingEngine parser;
    ArrayList<String> classes = new ArrayList();

    public static void main(String[] args2) throws HelperFunctions.NoArgumentValueProvided {
        HashMap<String, String> argv = HelperFunctions.generateArgumentMap(args2);
        if (args2.length == 0) {
            if (System.console() == null) {
                if (!ZPEHelperFunctions.isHeadless()) {
                    new SQARLEditorMain().setVisible(true);
                }
            } else {
                System.out.println("If you are running this from the console, please provide at least one command line argument. You can use -r to run an SQARL program directly.");
                System.exit(0);
            }
        } else {
            String first = args2[0];
            if (first.equals("-r") && argv.containsKey("-r")) {
                try {
                    String s = HelperFunctions.readFileAsString(argv.get("-r"), "utf-8");
                    try {
                        String output = SQARLParser.compileAndRunSQARL(s);
                        if (!output.isEmpty()) {
                            System.out.println(output);
                        }
                    }
                    catch (ExitHalt e) {
                        System.exit(HelperFunctions.stringToInteger(e.getMessage()));
                    }
                    catch (BreakPointHalt e) {
                        System.out.println(e.getMessage());
                    }
                    catch (CompileException | ZPERuntimeException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (IOException e) {
                    System.err.println("File not found!");
                }
            } else if (first.equals("-e")) {
                try {
                    String s = HelperFunctions.readFileAsString(argv.get("-e"), "utf-8");
                    String output = SQARLParser.compileSQARL(s);
                    if (!output.isEmpty()) {
                        System.out.println(output);
                    }
                }
                catch (IOException e) {
                    ZPE.log("SQARL Runtime error: " + e.getMessage());
                }
            } else if (first.equals("-python")) {
                try {
                    String s = HelperFunctions.readFileAsString(argv.get("-python"), "utf-8");
                    PythonTranspiler t = new PythonTranspiler();
                    String output = SQARLParser.compileSQARL(s);
                    String code = t.Transpile(ZPEKit.compile(output), "");
                    System.out.print(code);
                }
                catch (CompileException | IOException e) {
                    ZPE.log("SQARL Runtime error: " + e.getMessage());
                    System.out.println("Transpile error in the compiler");
                }
            } else if (first.equals("-g")) {
                if (argv.containsKey("--console")) {
                    ZPE.startConsole(args2);
                } else {
                    new SQARLEditorMain().setVisible(true);
                }
            } else {
                System.out.println("You have provided incorrect arguments to the application.");
            }
        }
    }

    private String varProcess(String s) {
        s = ((String)s).replace("count", "_count");
        if (!((String)(s = ((String)s).replace("list", "_list"))).startsWith("_")) {
            s = "_" + (String)s;
        }
        return s;
    }

    private void printError(String err) {
        System.err.println(err);
    }

    public static String compileSQARL(String s) {
        SQARLParser sqarl = new SQARLParser();
        return sqarl.parseToYASS(s);
    }

    public static String compileAndRunSQARL(String s) throws CompileException, ZPERuntimeException, ExitHalt, BreakPointHalt {
        SQARLParser sqarl = new SQARLParser();
        String yass = sqarl.parseToYASS(s);
        ZPEType out = ZPEKit.interpret(yass, 5);
        if (out != null) {
            return out.toString();
        }
        return "";
    }

    public String parseToYASS(String code) {
        StringBuilder output = new StringBuilder();
        this.parser = new ZenithParsingEngine(code, false, new SQARLParserByteCodes());
        this.parser.getNextSymbol();
        while (this.parser.getCurrentSymbol() != -2) {
            output.append(this.parseOne());
            this.parser.getNextSymbol();
        }
        return output.toString();
    }

    private String parseOne() {
        if (this.parser.getCurrentSymbol() == 0) {
            return this.compileDeclare() + System.lineSeparator();
        }
        if (this.parser.getCurrentSymbol() == 10) {
            return this.compileSet() + System.lineSeparator();
        }
        if (this.parser.getCurrentSymbol() == 7) {
            return this.compileSend() + System.lineSeparator();
        }
        if (this.parser.getCurrentSymbol() == 6) {
            return this.compileReceive() + System.lineSeparator();
        }
        if (this.parser.getCurrentSymbol() == 80) {
            return this.compileRecord() + System.lineSeparator();
        }
        if (this.parser.getCurrentSymbol() == 12) {
            return this.compileRepeat() + System.lineSeparator();
        }
        if (this.parser.getCurrentSymbol() == 14) {
            return this.compileIf() + System.lineSeparator();
        }
        if (this.parser.getCurrentSymbol() == 17) {
            return this.compileWhile() + System.lineSeparator();
        }
        if (this.parser.getCurrentSymbol() == 19) {
            return this.compileFor() + System.lineSeparator();
        }
        if (this.parser.getCurrentSymbol() == 71) {
            return this.compileProcedure() + System.lineSeparator();
        }
        if (this.parser.getCurrentSymbol() == 72) {
            return this.compileFunction() + System.lineSeparator();
        }
        if (this.parser.getCurrentSymbol() == 74) {
            return this.compileClass() + System.lineSeparator();
        }
        if (this.parser.getCurrentSymbol() == 11 && this.parser.peekAhead() == 60) {
            return this.compileFunctionCall() + System.lineSeparator();
        }
        return "-1";
    }

    private boolean isJoin(byte symb) {
        return symb == 40 || symb == 41 || symb == 49 || symb == 50 || symb == 52 || symb == 51 || symb == 53;
    }

    private boolean isValue(byte symb) {
        return symb == 11 || symb == 29 || symb == 30 || symb == 31 || symb == 32;
    }

    private boolean isComparison(byte symb) {
        return symb == 45 || symb == 46 || symb == 47 || symb == 48 || symb == 44 || symb == 43;
    }

    private String compileValue() {
        StringBuilder output = new StringBuilder();
        if (this.isValue(this.parser.getCurrentSymbol())) {
            if (this.parser.getCurrentSymbol() == 11 && this.parser.peekAhead() != 60) {
                output.append(this.compileVar()).append(" ");
            } else if (this.parser.getCurrentSymbol() == 11 && this.parser.peekAhead() == 60) {
                output.append(this.compileFunctionCall());
            } else if (this.parser.getCurrentSymbol() == 31) {
                output.append(this.parser.getCurrentWord().toLowerCase()).append(this.parser.getWhitespace());
            } else if (this.parser.getCurrentSymbol() == 30) {
                output.append("\"").append(this.parser.getCurrentWord()).append("\"").append(this.parser.getWhitespace());
            } else {
                output.append(this.parser.getWhitespace()).append(this.parser.getCurrentWord());
            }
        } else if (this.parser.getCurrentSymbol() == 62) {
            output = new StringBuilder("[");
            this.parser.getNextSymbol();
            while (this.parser.getCurrentSymbol() != 63) {
                output.append(this.compileValue());
                this.parser.getNextSymbol();
                if (this.parser.getCurrentSymbol() != 70) continue;
                output.append(",");
                this.parser.getNextSymbol();
            }
            output.append("]");
        }
        return output.toString();
    }

    private String compileVar() {
        Object output = this.varProcess(this.parser.getCurrentWord());
        if (this.parser.peekAhead() == 62) {
            this.parser.getNextSymbol();
            output = (String)output + this.compileIndex();
            this.parser.getNextSymbol();
        }
        return output;
    }

    private String compileExpression() {
        StringBuilder output = new StringBuilder();
        while (true) {
            if (this.parser.getCurrentSymbol() == 60) {
                output.append("(");
                this.parser.getNextSymbol();
                output.append(this.compileExpression());
            }
            output.append(this.compileValue());
            if (this.parser.peekAhead() == 61) {
                output.append(")");
                this.parser.getNextSymbol();
                return output.toString();
            }
            if (this.isComparison(this.parser.peekAhead())) {
                this.parser.getNextSymbol();
                output.append(this.parser.getCurrentWord()).append(this.parser.getWhitespace());
                this.parser.getNextSymbol();
                output.append(this.compileValue());
                if (this.parser.getCurrentSymbol() == 61) {
                    output.append(")");
                    this.parser.getNextSymbol();
                }
            }
            if (this.parser.peekAhead() == 54) {
                this.parser.getNextSymbol();
                this.parser.getNextSymbol();
                return output.append(" & ").append(this.compileExpression()).toString();
            }
            if (!this.isJoin(this.parser.peekAhead()) && !this.isJoin(this.parser.getCurrentSymbol())) {
                if (this.parser.peekAhead(2) == 61) {
                    this.parser.getNextSymbol();
                    output.append(")");
                }
                return output.toString();
            }
            if (this.isJoin(this.parser.peekAhead())) {
                this.parser.getNextSymbol();
            }
            if (this.parser.getCurrentSymbol() == 53) {
                output.append(" % ").append(this.parser.getWhitespace());
                this.parser.getNextSymbol();
                continue;
            }
            output.append(" ").append(this.parser.getCurrentWord().toLowerCase()).append(" ").append(this.parser.getWhitespace());
            this.parser.getNextSymbol();
        }
    }

    private String compileFunctionCall() {
        StringBuilder output = new StringBuilder();
        output.append(this.parser.getCurrentWord());
        this.parser.getNextSymbol();
        output.append("(");
        this.parser.getNextSymbol();
        while (this.parser.getCurrentSymbol() != 61) {
            output.append(this.parser.getCurrentWord());
            this.parser.getNextSymbol();
            if (this.parser.getCurrentSymbol() != 70) continue;
            this.parser.getNextSymbol();
            output.append(", ");
        }
        output.append(")");
        this.parser.getNextSymbol();
        return output.toString();
    }

    private String compileRepeat() {
        Object output = "";
        Object first = "";
        if (this.parser.getCurrentSymbol() == 12) {
            this.parser.getNextSymbol();
            first = "loop until (";
        }
        StringBuilder body = new StringBuilder();
        while (this.parser.getCurrentSymbol() != 13) {
            body.append(this.parseOne());
            this.parser.getNextSymbol();
        }
        if (this.parser.getCurrentSymbol() == 13) {
            this.parser.getNextSymbol();
            first = (String)first + this.compileExpression() + ")";
        }
        output = (String)output + (String)first + " " + body + "end loop ";
        return output;
    }

    private String compileIf() {
        StringBuilder output = new StringBuilder();
        if (this.parser.getCurrentSymbol() == 14) {
            this.parser.getNextSymbol();
            output.append("if (");
        }
        output.append(this.compileExpression());
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() != 15) {
            this.printError("Error. Expected THEN.");
        }
        output.append(") ");
        this.parser.getNextSymbol();
        while (this.parser.getCurrentSymbol() != 16 && this.parser.peekAhead() != 14 && this.parser.getCurrentSymbol() != 21) {
            output.append(this.parseOne());
            this.parser.getNextSymbol();
        }
        if (this.parser.getCurrentSymbol() == 21) {
            while (this.parser.getCurrentSymbol() == 21) {
                if (this.parser.peekAhead() == 14) {
                    if (this.parser.peekAhead() != 14) continue;
                    output.append(this.compileElseIf());
                    continue;
                }
                output.append("else ");
                this.parser.getNextSymbol();
                while (this.parser.getCurrentSymbol() != 16 && this.parser.peekAhead() != 14) {
                    output.append(this.parseOne());
                    this.parser.getNextSymbol();
                }
            }
        }
        this.parser.getNextSymbol();
        output.append("end if ");
        return output.toString();
    }

    private String compileElseIf() {
        StringBuilder output = new StringBuilder();
        this.parser.getNextSymbol();
        this.parser.getNextSymbol();
        output.append("elseif (");
        output.append(this.compileExpression());
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() != 15) {
            this.printError("Error. Expected THEN.");
        }
        output.append(") ");
        this.parser.getNextSymbol();
        while (this.parser.getCurrentSymbol() != 16 && this.parser.peekAhead() != 14 && this.parser.getCurrentSymbol() != 21) {
            output.append(this.parseOne());
            this.parser.getNextSymbol();
        }
        return output.toString();
    }

    private String compileWhile() {
        StringBuilder output = new StringBuilder();
        if (this.parser.getCurrentSymbol() == 17) {
            this.parser.getNextSymbol();
            output.append("while (");
        }
        output.append(this.compileExpression());
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() != 18) {
            this.printError("Error. Expected DO.");
        }
        output.append(") ");
        this.parser.getNextSymbol();
        while (this.parser.getCurrentSymbol() != 16 && this.parser.peekAhead() != 17) {
            output.append(this.parseOne());
            this.parser.getNextSymbol();
        }
        this.parser.getNextSymbol();
        output.append("end while ");
        return output.toString();
    }

    private String compileIndex() {
        Object output = "";
        output = (String)output + "[";
        this.parser.getNextSymbol();
        output = (String)output + this.compileExpression();
        output = (String)output + "]";
        return output;
    }

    private String compileFor() {
        StringBuilder output = new StringBuilder();
        boolean each = false;
        if (this.parser.getCurrentSymbol() == 19) {
            this.parser.getNextSymbol();
            output.append("for ");
        }
        if (this.parser.peekAhead() == 20) {
            output.append("each ");
            each = true;
        }
        output.append("(");
        if (this.parser.getCurrentSymbol() == 11 && !each) {
            String var = this.compileVar();
            output.append(var).append(" = ");
            this.parser.getNextSymbol();
            if (this.parser.getCurrentSymbol() != 4) {
                this.printError("Expected FROM.");
            }
            this.parser.getNextSymbol();
        }
        output.append(this.compileExpression());
        this.parser.getNextSymbol();
        if (each) {
            if (this.parser.getCurrentSymbol() != 4) {
                this.parser.getNextSymbol();
                output.append(" in ");
            }
            output.append(this.compileExpression());
        } else {
            this.parser.getNextSymbol();
            output.append(" to ");
            output.append(this.compileExpression());
            this.parser.getNextSymbol();
        }
        while (each && this.parser.getCurrentSymbol() != 18) {
            this.printError("Error. Expected DO.");
        }
        output.append(") ");
        this.parser.getNextSymbol();
        while (this.parser.getCurrentSymbol() != 16 && this.parser.peekAhead() != 19) {
            output.append(this.parseOne());
            this.parser.getNextSymbol();
        }
        this.parser.getNextSymbol();
        output.append("end for ");
        return output.toString();
    }

    private String compileSet() {
        Object output = "";
        if (this.parser.getCurrentSymbol() == 10) {
            this.parser.getNextSymbol();
        }
        if (this.parser.getCurrentSymbol() != 11) {
            this.printError("Error. Expected IDENTIFIER.");
        }
        String var = this.compileVar();
        output = (String)output + var + " = ";
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() != 8) {
            this.printError("Error. Expected TO IN SET.");
        }
        this.parser.getNextSymbol();
        if (!this.isValue(this.parser.getCurrentSymbol()) && this.parser.getCurrentSymbol() != 60) {
            this.printError("Error. Expected TYPE.");
        }
        output = (String)output + this.compileExpression();
        return output;
    }

    private String compileDeclare() {
        StringBuilder output = new StringBuilder();
        if (this.parser.getCurrentSymbol() == 0) {
            this.parser.getNextSymbol();
        }
        if (this.parser.getCurrentSymbol() != 11) {
            this.printError("Error. Expected IDENTIFIER.");
        }
        String var = this.varProcess(this.parser.getCurrentWord());
        output.append(var).append(this.parser.getWhitespace()).append("=");
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() == 1) {
            output.append(this.parser.getWhitespace());
            this.parser.getNextSymbol();
            if (this.parser.getCurrentSymbol() != 2) {
                this.printError("Error. Expected TYPE.");
            }
            if (this.parser.getCurrentSymbol() == -1) {
                this.parser.getNextSymbol();
                if (this.parser.getCurrentSymbol() != 76) {
                    this.printError("Error. Expected OF.");
                }
                this.parser.getNextSymbol();
                if (this.parser.getCurrentSymbol() != 2 && this.parser.getCurrentSymbol() != -1) {
                    this.printError("Error. Expected TYPE.");
                }
                if (this.parser.getCurrentSymbol() == -1) {
                    this.parser.getNextSymbol();
                    if (this.parser.getCurrentSymbol() != 76) {
                        this.printError("Error. Expected OF.");
                    }
                    this.parser.getNextSymbol();
                    if (this.parser.getCurrentSymbol() != 2 && this.parser.getCurrentSymbol() != -1) {
                        this.printError("Error. Expected TYPE.");
                    }
                    this.parser.getNextSymbol();
                    if (this.parser.getCurrentSymbol() != 3) {
                        this.printError("Error. Expected INITIALLY.");
                    }
                    this.parser.getNextSymbol();
                    if (this.parser.peekAhead() == 63) {
                        return output.append("[[]]").toString();
                    }
                    if (this.parser.getCurrentWord().isEmpty()) {
                        output.append("[[").append("\"\"").append("]]");
                    } else {
                        output.append("[[").append(this.parser.getCurrentWord()).append("]]");
                    }
                } else {
                    this.parser.getNextSymbol();
                    if (this.parser.getCurrentSymbol() != 3) {
                        this.printError("Error. Expected INITIALLY.");
                    }
                    this.parser.getNextSymbol();
                    this.parser.getNextSymbol();
                    if (this.parser.getCurrentWord().isEmpty()) {
                        output.append("[").append("\"\"").append("]");
                    } else {
                        output.append("[").append(this.parser.getCurrentWord()).append("]");
                    }
                }
                this.parser.getNextSymbol();
                this.parser.getNextSymbol();
                if (this.parser.getCurrentSymbol() != 52) {
                    this.printError("Error. Expected MULT.");
                }
                this.parser.getNextSymbol();
                output.append(" * ").append(this.parser.getCurrentWord());
                return output.toString();
            }
            this.parser.getNextSymbol();
        }
        if (this.parser.getCurrentSymbol() != 3) {
            this.printError("Error. Expected INITIALLY.");
        }
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() == 4) {
            this.parser.getNextSymbol();
            if (this.parser.getCurrentSymbol() == 5) {
                output.append("auto_input()");
            }
        } else if (this.parser.getCurrentSymbol() == 11 && this.parser.peekAhead() == 60 && this.classes.contains(this.parser.getCurrentWord())) {
            output.append(" new ").append(this.parser.getCurrentWord()).append(" (");
            this.parser.getNextSymbol();
            this.parser.getNextSymbol();
            while (this.parser.getCurrentSymbol() != 61) {
                output.append(this.parser.getCurrentWord());
                this.parser.getNextSymbol();
                if (this.parser.getCurrentSymbol() != 70) continue;
                output.append(", ");
                this.parser.getNextSymbol();
            }
            output.append(") ");
        } else if (this.parser.getCurrentSymbol() == 62) {
            output.append(this.compileValue());
        } else {
            if (!this.isValue(this.parser.getCurrentSymbol())) {
                this.printError("Error. Expected TYPE.");
            }
            output.append(this.compileValue());
        }
        output.append(this.parser.getWhitespace());
        return output.toString();
    }

    private String compileProcedure() {
        StringBuilder output = new StringBuilder("function ");
        this.parser.getNextSymbol();
        output.append(this.parser.getCurrentWord());
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() != 60) {
            this.printError("Error. Expected LBRACKET.");
        }
        output.append(" (");
        this.parser.getNextSymbol();
        while (this.parser.getCurrentSymbol() != 61) {
            if (this.isType()) {
                output.append(this.convertType()).append(" ");
                this.parser.getNextSymbol();
            } else {
                this.printError("Expected type in PROCEDURE signature parameters.");
            }
            output.append(this.parser.getCurrentWord());
            this.parser.getNextSymbol();
            if (this.parser.getCurrentSymbol() != 70) continue;
            output.append(", ");
            this.parser.getNextSymbol();
        }
        output.append(") ");
        this.parser.getNextSymbol();
        while (this.parser.getCurrentSymbol() != 16 && this.parser.peekAhead() != 71) {
            output.append(this.parseOne());
            this.parser.getNextSymbol();
        }
        this.parser.getNextSymbol();
        output.append(" end function ");
        return output.toString();
    }

    private String compileFunction() {
        boolean returnFound = false;
        StringBuilder output = new StringBuilder("function ");
        this.parser.getNextSymbol();
        output.append(this.parser.getCurrentWord());
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() != 60) {
            this.printError("Error. Expected LBRACKET.");
        }
        output.append(" (");
        this.parser.getNextSymbol();
        while (this.parser.getCurrentSymbol() != 61) {
            if (this.isType()) {
                output.append(this.convertType()).append(" ");
                this.parser.getNextSymbol();
            } else {
                this.printError("Expected type in PROCEDURE signature parameters.");
            }
            output.append(this.parser.getCurrentWord());
            this.parser.getNextSymbol();
            if (this.parser.getCurrentSymbol() != 70) continue;
            output.append(", ");
            this.parser.getNextSymbol();
        }
        output.append(") ");
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() == 79) {
            this.parser.getNextSymbol();
            this.parser.getNextSymbol();
        }
        while (this.parser.getCurrentSymbol() != 16 && this.parser.peekAhead() != 72) {
            if (this.parser.getCurrentSymbol() == 73) {
                output.append("return ");
                this.parser.getNextSymbol();
                output.append(this.compileExpression());
                returnFound = true;
            } else {
                output.append(this.parseOne());
            }
            this.parser.getNextSymbol();
        }
        this.parser.getNextSymbol();
        output.append(" end function");
        if (!returnFound) {
            this.printError("RETURN not provided in a function");
        }
        return output.toString();
    }

    private String compileClass() {
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() != 11) {
            this.printError("IDENTIFIER not provided for a class");
        }
        StringBuilder output = new StringBuilder();
        output.append("class ").append(this.parser.getCurrentWord()).append(" ").append(System.lineSeparator());
        this.classes.add(this.parser.getCurrentWord());
        if (this.parser.getNextSymbol() == 75) {
            if (this.parser.getNextSymbol() != 58) {
                this.printError("LBRACE expected");
            }
            this.parser.getNextSymbol();
            StringBuilder params = new StringBuilder();
            params.append("( ");
            while (this.parser.getCurrentSymbol() != 59) {
                if (this.isType()) {
                    params.append(this.convertType()).append(" ");
                    this.parser.getNextSymbol();
                } else {
                    this.printError("Expected type in PROCEDURE signature parameters.");
                }
                params.append(this.parser.getCurrentWord());
                this.parser.getNextSymbol();
                if (this.parser.getCurrentSymbol() != 70) continue;
                params.append(", ");
                this.parser.getNextSymbol();
            }
            params.append(") ");
        }
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() != 77) {
            this.printError("METHODS expected in class definition.");
        }
        this.parser.getNextSymbol();
        while (this.parser.getCurrentSymbol() != 16 || this.parser.peekAhead() != 74) {
            if (this.parser.getCurrentSymbol() == 72) {
                output.append(this.compileFunction()).append(System.lineSeparator());
                this.parser.getNextSymbol();
                continue;
            }
            if (this.parser.getCurrentSymbol() != 71) continue;
            output.append(this.compileProcedure()).append(System.lineSeparator());
            this.parser.getNextSymbol();
        }
        output.append(" end class");
        this.parser.getNextSymbol();
        return output.toString();
    }

    private String compileSend() {
        Object output = "";
        if (this.parser.getCurrentSymbol() == 7) {
            this.parser.getNextSymbol();
        }
        output = (String)output + "print(";
        if (!this.isValue(this.parser.getCurrentSymbol())) {
            this.printError("Error. Expected VALUE.");
        }
        output = (String)output + this.compileExpression();
        if (this.parser.getCurrentSymbol() != 8) {
            this.parser.getNextSymbol();
        }
        if (this.parser.getCurrentSymbol() != 8) {
            this.printError("Error. Expected TO.");
        }
        this.parser.getNextSymbol();
        output = (String)output + ")";
        if (this.parser.getCurrentSymbol() != 9) {
            this.printError("Error. Expected DISPLAY.");
        }
        output = (String)output + this.parser.getWhitespace();
        return output;
    }

    private String compileRecord() {
        StringBuilder output = new StringBuilder();
        if (this.parser.getCurrentSymbol() == 80) {
            this.parser.getNextSymbol();
        }
        if (this.parser.getCurrentSymbol() != 11) {
            this.printError("Error. Expected IDENTIFIER.");
        }
        String name = this.parser.getCurrentWord();
        output.append("record structure ").append(name).append(" {");
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() != 75) {
            this.printError("Error. Expected IS.");
        }
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() != 58) {
            this.printError("Error. Expected LBRACE.");
        }
        this.parser.getNextSymbol();
        boolean hasLooped = false;
        while (this.parser.getCurrentSymbol() != 59) {
            String t;
            if (this.parser.getCurrentSymbol() == 70) {
                this.parser.getNextSymbol();
            }
            if (this.parser.getCurrentSymbol() != 2) {
                this.printError("Error. Expected TYPE.");
            }
            if ((t = this.parser.getCurrentWord().toLowerCase()).equalsIgnoreCase("integer") || t.equalsIgnoreCase("real")) {
                t = "number";
            }
            if (hasLooped) {
                output.append(", ");
            }
            output.append(t).append(" ");
            this.parser.getNextSymbol();
            if (this.parser.getCurrentSymbol() != 11) {
                this.printError("Error. Expected IDENTIFIER.");
            }
            output.append(this.parser.getCurrentWord());
            this.parser.getNextSymbol();
            hasLooped = true;
        }
        output.append("}");
        return output.toString();
    }

    private String compileReceive() {
        Object output = "";
        if (this.parser.getCurrentSymbol() == 6) {
            this.parser.getNextSymbol();
        }
        if (this.parser.getCurrentSymbol() != 11) {
            this.printError("Error. Expected IDENTIFIER.");
        }
        output = (String)output + this.varProcess(this.parser.getCurrentWord());
        this.parser.getNextSymbol();
        if (this.parser.getCurrentSymbol() != 4) {
            this.printError("Error. Expected FROM.");
        }
        this.parser.getNextSymbol();
        if (this.isType()) {
            boolean brackets = false;
            if (this.parser.getCurrentSymbol() == 60) {
                this.parser.getNextSymbol();
                brackets = true;
            }
            boolean close = false;
            if (this.parser.getCurrentWord().equalsIgnoreCase("integer")) {
                output = (String)output + " ceiling (";
                close = true;
            }
            this.parser.getNextSymbol();
            if (brackets && this.parser.getCurrentSymbol() == 61) {
                this.parser.getNextSymbol();
            }
            if (this.parser.getCurrentSymbol() != 5) {
                this.printError("Error. Expected INPUT.");
            }
            if (close) {
                output = (String)output + ")";
            }
        } else if (this.parser.getCurrentSymbol() != 5) {
            this.printError("Error. Expected INPUT.");
        }
        output = (String)output + this.parser.getWhitespace() + " = auto_input()";
        return output;
    }

    private boolean isType() {
        return this.parser.getCurrentSymbol() == 2 || this.parser.getCurrentSymbol() == 60 && this.parser.peekAhead() == 2;
    }

    private String convertType() {
        String output = "";
        if (this.parser.getCurrentWord().equals("INTEGER") || this.parser.getCurrentWord().equals("REAL")) {
            return "number";
        }
        if (this.parser.getCurrentWord().equals("STRING") || this.parser.getCurrentWord().equals("CHARACTER")) {
            return "string";
        }
        if (this.parser.getCurrentWord().equals("BOOLEAN")) {
            return "boolean";
        }
        return output;
    }
}

