/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Taskbar;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;

public class BalfSplashScreen
extends JWindow {
    String loadingText;
    final JLabel loading;

    public BalfSplashScreen(String appName, String name, String copyright, String loadingMessage, ImageIcon logo, Color backgroundColour, ImageIcon appIcon) {
        System.setProperty("apple.awt.application.name", appName);
        System.setProperty("apple.awt.application.appearance", "system");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
            try {
                if (Taskbar.isTaskbarSupported()) {
                    Taskbar taskbar = Taskbar.getTaskbar();
                    taskbar.setIconImage(appIcon.getImage());
                }
            }
            catch (Exception taskbar) {
                // empty catch block
            }
        }
        JPanel content = new JPanel();
        content.setBackground(backgroundColour);
        content.setLayout(new BorderLayout(10, 10));
        this.loadingText = loadingMessage;
        JLabel logoLabel = null;
        if (logo != null) {
            Image scaledImage = logo.getImage().getScaledInstance(64, 64, 4);
            logoLabel = new JLabel(new ImageIcon(scaledImage), 0);
            logoLabel.setHorizontalAlignment(0);
        }
        JLabel title = new JLabel(name, 0);
        title.setFont(new Font("Segoe UI", 1, 26));
        title.setForeground(Color.WHITE);
        this.loading = new JLabel(loadingMessage, 0);
        this.loading.setFont(new Font("Segoe UI", 0, 14));
        this.loading.setForeground(Color.LIGHT_GRAY);
        content.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        if (logo != null) {
            content.add((Component)logoLabel, "North");
        }
        JPanel mainContent = new JPanel(new BorderLayout());
        JLabel copyrightLbl = new JLabel(copyright, 0);
        copyrightLbl.setFont(new Font("Segoe UI", 0, 12));
        copyrightLbl.setForeground(Color.WHITE);
        mainContent.setSize(this.getWidth(), 50);
        mainContent.setPreferredSize(this.getSize());
        mainContent.add((Component)title, "North");
        mainContent.add((Component)copyrightLbl, "Center");
        mainContent.setOpaque(false);
        content.add((Component)mainContent, "Center");
        content.add((Component)this.loading, "South");
        this.setContentPane(content);
        this.setSize(350, 220);
        this.setLocationRelativeTo(null);
        this.setShape(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 30.0, 30.0));
        Timer timer = new Timer(600, e -> {
            if (this.loading.getText().endsWith("...")) {
                this.loading.setText(this.loadingText);
            } else if (this.loading.getText().endsWith("..")) {
                this.loading.setText(this.loadingText + "...");
            } else if (this.loading.getText().endsWith(".")) {
                this.loading.setText(this.loadingText + "..");
            } else {
                this.loading.setText(this.loadingText + ".");
            }
        });
        timer.start();
    }

    public void showFor(int milliseconds) {
        this.setVisible(true);
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.setVisible(false);
        this.dispose();
    }
}

