/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;

public class BalfLafManager
extends UIManager.LookAndFeelInfo {
    boolean darkMode = false;
    private Color darkColorForeground = Color.WHITE;
    private Color darkColorBackground = new Color(21, 21, 21);
    private Color darkColorComponentBackground = new Color(60, 60, 60);
    private Color darkColorInputBackground = Color.DARK_GRAY;
    private Color darkColorMenuHoverBackground = new Color(120, 120, 120);
    static BalfLafManager instance;
    private final List<DarkModeListener> listeners = new ArrayList<DarkModeListener>();

    private BalfLafManager() {
        super("BalfLafManager", "balflaf");
    }

    public static BalfLafManager getInstance() {
        if (instance == null) {
            instance = new BalfLafManager();
        }
        return instance;
    }

    public void addListener(DarkModeListener listener) {
        this.listeners.add(listener);
        listener.onDarkModeChanged(this.darkMode);
    }

    public void removeListener(DarkModeListener listener) {
        this.listeners.remove(listener);
    }

    public void toggleDarkMode(boolean enabled) {
        for (DarkModeListener l : this.listeners) {
            this.darkMode = enabled;
            l.onDarkModeChanged(enabled);
        }
    }

    public void setDarkColorForeground(Color color) {
        this.darkColorForeground = color;
    }

    public void setDarkColorBackground(Color color) {
        this.darkColorBackground = color;
    }

    public void setDarkColorInputBackground(Color color) {
        this.darkColorInputBackground = color;
    }

    public void setDarkColorComponentBackground(Color color) {
        this.darkColorComponentBackground = color;
    }

    public void setDarkColorMenuHoverBackground(Color color) {
        this.darkColorMenuHoverBackground = color;
    }

    public Color getDarkColorForeground() {
        return this.darkColorForeground;
    }

    public Color getDarkColorBackground() {
        return this.darkColorBackground;
    }

    public Color getDarkColorInputBackground() {
        return this.darkColorInputBackground;
    }

    public Color getDarkColorComponentBackground() {
        return this.darkColorComponentBackground;
    }

    public Color getDarkColorMenuHoverBackground() {
        return this.darkColorMenuHoverBackground;
    }

    public boolean isDarkModeEnabled() {
        return this.darkMode;
    }

    public static interface DarkModeListener {
        public void onDarkModeChanged(boolean var1);
    }
}

